<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Verification - Secure Access</title>
    <meta name="description" content="Secure account verification process">
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Security Headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>🔒</text></svg>">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f8fafc;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            border: 1px solid #e2e8f0;
            max-width: 480px;
            width: 100%;
            text-align: center;
        }
        
        .logo {
            width: 60px;
            height: 60px;
            background: #3b82f6;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            font-size: 24px;
            color: white;
        }
        
        .title {
            font-size: 24px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 8px;
        }
        
        .subtitle {
            font-size: 16px;
            color: #64748b;
            margin-bottom: 32px;
            line-height: 1.5;
        }
        
        .loading-section {
            margin: 32px 0;
        }
        
        .loading-text {
            font-size: 14px;
            color: #475569;
            margin-bottom: 16px;
            font-weight: 500;
        }
        
        .spinner {
            width: 32px;
            height: 32px;
            border: 3px solid #e2e8f0;
            border-top: 3px solid #3b82f6;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 16px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .progress-container {
            width: 100%;
            height: 4px;
            background: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
        }
        
        .progress-bar {
            height: 100%;
            background: #3b82f6;
            border-radius: 2px;
            width: 0%;
            transition: width 0.3s ease;
        }
        
        .success-section {
            display: none;
        }
        
        .success-section.show {
            display: block;
            animation: fadeIn 0.4s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .success-icon {
            width: 60px;
            height: 60px;
            background: #10b981;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            font-size: 24px;
            color: white;
        }
        
        .success-title {
            font-size: 20px;
            font-weight: 600;
            color: #059669;
            margin-bottom: 8px;
        }
        
        .success-message {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 24px;
            line-height: 1.5;
        }
        
        .continue-btn {
            background: #3b82f6;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.2s ease;
            text-decoration: none;
            display: inline-block;
        }
        
        .continue-btn:hover {
            background: #2563eb;
        }
        
        .security-notice {
            margin-top: 24px;
            padding: 12px;
            background: #f1f5f9;
            border-radius: 6px;
            border-left: 3px solid #3b82f6;
        }
        
        .security-text {
            font-size: 12px;
            color: #475569;
            line-height: 1.4;
        }
        
        /* Mobile */
        @media (max-width: 640px) {
            .container {
                padding: 24px;
                margin: 16px;
            }
            
            .title {
                font-size: 20px;
            }
            
            .subtitle {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Loading State -->
        <div id="loading-state">
            <div class="logo">🔒</div>
            <h1 class="title">Security Verification</h1>
            <p class="subtitle">
                Please wait while we verify your browser and check security compliance.
            </p>
            
            <div class="loading-section">
                <div class="loading-text" id="loading-text">Checking browser security...</div>
                <div class="spinner"></div>
                <div class="progress-container">
                    <div class="progress-bar" id="progress-bar"></div>
                </div>
            </div>
            
            <div class="security-notice">
                <div class="security-text">
                    <strong>Security Notice:</strong> This verification ensures your account remains secure and protected.
                </div>
            </div>
        </div>
        
        <!-- Success State -->
        <div id="success-state" class="success-section">
            <div class="success-icon">✅</div>
            <h1 class="success-title">Verification Complete</h1>
            <p class="success-message">
                Your browser has been verified and meets all security requirements. 
                You may now proceed to access your account.
            </p>
            <a href="index.php" class="continue-btn">Click here to continue</a>
            
            <div class="security-notice">
                <div class="security-text">
                    <strong>Next Step:</strong> Complete your account verification by providing the required information.
                </div>
            </div>
        </div>
    </div>
    
    <script>
        const loadingMessages = [
            'Checking browser security...',
            'Verifying SSL certificate...',
            'Scanning for threats...',
            'Validating protocols...',
            'Finalizing verification...'
        ];
        
        const loadingText = document.getElementById('loading-text');
        const progressBar = document.getElementById('progress-bar');
        const loadingState = document.getElementById('loading-state');
        const successState = document.getElementById('success-state');
        
        let messageIndex = 0;
        let progress = 0;
        
        function updateLoading() {
            loadingText.textContent = loadingMessages[messageIndex];
            messageIndex = (messageIndex + 1) % loadingMessages.length;
            
            progress += Math.random() * 20 + 10;
            if (progress > 100) progress = 100;
            
            progressBar.style.width = progress + '%';
            
            if (progress >= 100) {
                setTimeout(() => {
                    loadingState.style.display = 'none';
                    successState.classList.add('show');
                }, 800);
                return;
            }
            
            setTimeout(updateLoading, Math.random() * 600 + 400);
        }
        
        setTimeout(updateLoading, 1000);
    </script>
</body>
</html>
